<?php
/** 
 *------------------------------------------------------------------------------
 * @package       T3 Framework for Joomla!
 *------------------------------------------------------------------------------
 * @copyright     Copyright (C) 2004-2013 JoomlArt.com. All Rights Reserved.
 * @license       GNU General Public License version 2 or later; see LICENSE.txt
 * @authors       JoomlArt, JoomlaBamboo, (contribute to this project at github 
 *                & Google group to become co-author)
 * @Google group: https://groups.google.com/forum/#!forum/t3fw
 * @Link:         http://t3-framework.org 
 *------------------------------------------------------------------------------
 */

defined('_JEXEC') or die;
?>

<!DOCTYPE html>
<html lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>"
	  class='<jdoc:include type="pageclass" />'>

<head>
	<jdoc:include type="head" />
	<?php $this->loadBlock('head') ?>
	<?php $this->addCss('home') ?>
</head>

<body>

<div class="t3-wrapper"> <!-- Need this wrapper for off-canvas menu. Remove if you don't use of-canvas -->

	<?php $this->loadBlock('header') ?>
	
	<?php $this->loadBlock('navhelper') ?>
	
	<?php $this->loadBlock('slideshow') ?>

	<?php $this->loadBlock('mainbody-default') ?>

	<?php $this->loadBlock('footer') ?>

</div>

<!-- Style Switcher
================================================== -->

<section id="style-switcher">
   <span><i class="fa fa-cog fa-spin"></i></span>
   <h2>Style Selector </h2>
  <div>
    <h3>Layout Style</h3>
    <div class="layout-style">
      <select id="layout-style">
        <option value="1">Wide</option>
        <option value="2">Boxed</option>
      </select>
    </div>
    <h3>Predefined Colors</h3>
    <ul class="colors" id="colors">
	 <li><a href="index.php" class="orange" ></a></li>
	  <li><a href="index.php/red" class="red"></a></li>
      <li><a href="index.php/yellow" class="yellow"></a></li>    
      <li><a href="index.php/green" class="green"></a></li> 
      <li><a href="index.php/blue" class="blue"></a></li>
      <li><a href="index.php/gold" class="gold"></a></li>
      <li><a href="index.php/light-green" class="lightgreen"></a></li>
      <li><a href="index.php/light-orange" class="lightorange"></a></li> 
      <li><a href="index.php/light-red" class="lightred"></a></li>
    </ul>
    <h3>Background Image</h3>
    <ul class="colors bg" id="bg">
      <li><a href="#" class="bg1"></a></li>
      <li><a href="#" class="bg2"></a></li>
      <li><a href="#" class="bg3"></a></li>
      <li><a href="#" class="bg4"></a></li>
      <li><a href="#" class="bg5"></a></li>
      <li><a href="#" class="bg6"></a></li>
    </ul>
  </div>
</section>

</body>
</html>
